Attribute VB_Name = "modFunctions"
Option Explicit
Private Declare Function inet_ntoa Lib "wsock32.dll" (ByVal Addr As Long) As Long
Private Declare Function lstrcpyA Lib "kernel32" (ByVal RetVal As String, ByVal Ptr As Long) As Long
Private Declare Function lstrlenA Lib "kernel32" (lpString As Any) As Long
Private Declare Function FlashWindow Lib "user32" (ByVal hwnd As Long, ByVal bInvert As Long) As Long

Public Enum TimeFormatType
    DaysHoursMinutesSecondsMilliseconds = 0
    DaysHoursMinutesSeconds = 1
    DHMS = 2
    DaysHoursMinutes = 3
    DHMSshort = 4
    All = 5
    All2 = 6
    All3 = 7
    SecondFormat = 8
End Enum

Public Sub AddC(ByVal Index As Integer, ByRef RTB As RichTextBox, ByVal RecordInfo As Boolean, ParamArray saElements() As Variant)
    
    'Append to the RichTextBox
    If (BotIndex = Index) Then
        If (RecordInfo) Then
            Dim i As Integer
            With RTB
                .SelStart = 99999999
                .SelLength = 50000
                .SelColor = COLORS.ID_COLOR_TIME
                .SelText = "[" & Format(Time, "hh:mm:ss") & "] "
                .SelStart = 99999999
            End With
        End If
        
        For i = LBound(saElements) To UBound(saElements) Step 2
            With RTB
                .SelStart = 99999999
                .SelLength = 0
                .SelColor = saElements(i)
                .SelText = saElements(i + 1) & Left$(vbCrLf, -2 * CLng((i + 1) = UBound(saElements)))
                .SelStart = 99999999
            End With
        Next i
    End If
    
    If (RecordInfo) Then
        Call clearTopLineFromRTB(RTB, Index)
    End If
        
    'Store information if needed.
    If (RecordInfo) Then
        Dim RTBInformation() As Variant
        RTBInformation = saElements()
        Select Case RTB
            Case frmMain.rtbChat
                Call ProfileHandler(Index).RTBHandler.addRTBInformation(Index, "CHAT", RTBInformation())
            Case frmMain.rtbWhisper
                Call ProfileHandler(Index).RTBHandler.addRTBInformation(Index, "WHISPER", RTBInformation())
        End Select
    End If
End Sub

Private Sub clearTopLineFromRTB(ByRef RTB As RichTextBox, ByRef Index As Integer)
    Dim LOGHandler As New clsLogging
    'Remove top line if needed
    If (BotIndex = Index) Then
        'Set 20000 to any number value, this is just a general one.
        If (Len(RTB.Text) > 20000) Then
            With RTB
                'Beginning of the start of the first line.
                .SelStart = 0
                'Find the spot in the text of the first newline and add 1 to get the full line.
                .SelLength = (InStr(RTB.Text, vbCrLf) + 1)
                
                If (ProfileHandler(Index).OPTION_LOG_CHAT) Then
                    'Log Chat that is going to be removed
                    Call LOGHandler.logChat(.SelText, "Logs", Bots(Index).Profile)
                End If
                
                'Delete first line from the current bot index's array list.
                Call ProfileHandler(Index).RTBHandler.removeFirstRTBArrayIndex
                
                'Set all text from start to length to a nullstring value to clear it.
                .SelText = vbNullString
                .SelStart = 99999999
            End With
        End If
    Else
        If (ProfileHandler(Index).RTBHandler.uboundRTBInformation >= 101) Then  'I think this is best, can tweak it later :/
            'Log Chat that is going to be removed
            'Call LOGHandler.logChat(ProfileHandler.Item (Index).RTBHandler.uboundRTBInformationText, "Logs", Bots(Index).Profile)
            
            'Delete first line from the current bot index's array list.
            Call ProfileHandler(Index).RTBHandler.removeFirstRTBArrayIndex
        End If
    End If
End Sub

Public Function ReadINI(ByVal strMain As String, ByVal strValue As String, ByVal strFile As String, Optional ByVal strSub As String) As String
    Close #1
    
    'No file specified.
    If (strFile = vbNullString) Then Exit Function
    
    Open strFile For Append As #1
    Close #1
    
    Dim strInput    As String
    Dim Found_Main  As Boolean
    Dim Found_Sub   As Boolean
    Open strFile For Input As #1
        Do Until EOF(1)
            Line Input #1, strInput
            If Left$(strInput, 1) <> "//" Then
                strInput = Replace$(strInput, vbTab, Space(1))
                strInput = Trim$(strInput)
                     'No Sub bracket
                If (strSub = vbNullString) Then
                    If (Found_Main) Then
                        Dim Splt() As String
                        If (InStr(strInput, "=")) Then
                            Splt() = Split(strInput, "=")
                            If (StrComp(Splt(0), strValue, vbTextCompare) = 0) Then
                                ReadINI = Right$(strInput, Len(strInput) - (Len(Splt(0)) + 1))
                                Found_Main = False
                                Close #1
                                Exit Function
                            End If
                        End If
                    End If
                    If (StrComp(strInput, strMain & " {", vbTextCompare) = 0) Then
                        Found_Main = True
                    End If
                Else 'Sub bracket
                    If (Found_Sub) Then
                        'Did not find the value in sub yet, provide a generic value.
                        If (strSub <> vbNullString And Left$(strInput, 1) = "}") Then
                            ReadINI = vbNullString 'Default value
                            Exit Function
                        End If
                        If (InStr(strInput, "=")) Then
                            Splt() = Split(strInput, "=")
                            If (StrComp(Splt(0), strValue, vbTextCompare) = 0) Then
                                ReadINI = Right$(strInput, Len(strInput) - (Len(Splt(0)) + 1))
                                Found_Main = False
                                Close #1
                                Exit Function
                            End If
                        End If
                    End If
                    If (Found_Main) Then
                        If (Left(strInput, 2) = "};") Then 'End of profile
                            ReadINI = 0
                            Exit Function
                        End If
                        If (StrComp(strInput, strSub & " {", vbTextCompare) = 0) Then
                            Found_Sub = True
                        End If
                    End If
                    If (StrComp(strInput, strMain & " {", vbTextCompare) = 0) Then
                        Found_Main = True
                    End If
                End If
                strInput = vbNullString
            End If
        Loop
    Close #1
    ReadINI = vbNullString 'Default value
End Function

Public Function getDataList(ByRef strMain As String, ByRef strFile As String) As String()
    'Function: Retrieves all the data between a current section and returns it via an array so you can parse it later.
    
    'Example:
    'Data {
    '   data1
    '   data2
    '}
    'Returns data1 and data2 in a string array.
    
    Dim strInput        As String
    Dim SectionFound    As Boolean
    Dim DataArray()     As String
    
    'Empty array
    ReDim DataArray(0)
    
    'Just in case file specified is null
    If (strMain = vbNullString) Then Exit Function
    
    Close #1
    
    'Make sure the file exists
    Open strFile For Append As #1
    Close #1
    
    Open strFile For Input As #1
        Do Until EOF(1)
            Line Input #1, strInput
            strInput = Replace$(strInput, vbTab, vbNullString)
            
            If (strInput <> "};" And SectionFound = True) Then 'Add to array list so long as the section is found.
                'Found section store all elements between section in an array so we can return it later.
                DataArray(UBound(DataArray)) = strInput
                ReDim Preserve DataArray(UBound(DataArray) + 1)
            ElseIf (strInput = "};" And SectionFound = True) Then 'Section was found and we found the brace that ends it, so return.
                'Found data, return
                getDataList = DataArray
                Close #1
                Exit Function
            End If
            
            'Found Section
            If (SectionFound = False) Then
                If StrComp(strInput, strMain & " {", vbTextCompare) = 0 Then
                    SectionFound = True
                End If
            End If
        Loop
    Close #1
    'Fail safe:
    'Return data in section
    getDataList = DataArray
End Function

Public Function GetInetStrFromPtr(Address As Long) As String
   GetInetStrFromPtr = GetStrFromPtrA(inet_ntoa(Address))
End Function

Public Function GetStrFromPtrA(ByVal lpszA As Long) As String
   GetStrFromPtrA = String$(lstrlenA(ByVal lpszA), 0)
   Call lstrcpyA(ByVal GetStrFromPtrA, ByVal lpszA)
End Function

Public Sub Flash_Window()
    Call FlashWindow(frmMain.hwnd, &H0)
    Call FlashWindow(frmMain.hwnd, &H1)
End Sub

Public Function Wildcard(ByVal uName As String, ByVal Check As String) As Boolean
    Call PrepareCheck(Check)
    If uName = Empty Then
       Wildcard = False
       Exit Function
    End If
    If LCase$(uName) Like LCase$(Check) Then Wildcard = True
End Function

Private Sub PrepareCheck(ByRef tocheck As String)
    tocheck = Replace(tocheck, "[", "")
    tocheck = Replace(tocheck, "]", "")
    tocheck = Replace(tocheck, "", "[[]")
    tocheck = Replace(tocheck, "", "[]]")
    tocheck = Replace(tocheck, "#", "[#]")
    tocheck = Replace(tocheck, "-", "[-]")
End Sub

Public Function parseNewsData(ByVal NewsItem As String) As Integer
    '// Format:
    '[NEWS]<build #><disabled bool: 0, 1><news>
    '               ^ is split by the invisible space: ALT+0160
    'Special case: A build type of -1 applies to all builds
    '; = skip
        
    NewsItem = Right$(NewsItem, Len(NewsItem) - 6)
    
    Dim NewsDelimiter   As String
    NewsDelimiter = Chr$(44) & Chr$(44) ',,
    
    'Split the news message up into readable parts: <Build>, <Disabled version bool>, <news>
    Dim spltNewsItem()  As String
    If (InStr(NewsItem, NewsDelimiter)) Then
        spltNewsItem() = Split(NewsItem, NewsDelimiter)
    End If
    
    If (UBound(spltNewsItem) >= 2) Then
        '0 -> Build #
        'Correct news item to the corresponding build, special case applies here
        If (CLng(spltNewsItem(0)) = -1 Or CLng(spltNewsItem(0)) = App.Revision) Then
            'Disable version? 0 = no; 1 = yes
            If (spltNewsItem(1) = "1") Then
                'Disable version
                Call MsgBox("This version has been disabled please update your client: " & Support_Site, vbExclamation, "Alert")
                End
            Else 'Version is NOT disabled, continue to get news.
                AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_INFO, "     " & spltNewsItem(2)
            End If
        Else
            'Return non-corresponding build number
            parseNewsData = CLng(spltNewsItem(0))
        End If
    Else 'News item doesn't fit format...Oh No!
        AddC BotIndex, frmMain.rtbChat, True, COLORS.BOT_COLOR_FAILED, "Error: Malformed news item, contact the authors. -> " & NewsItem
    End If
End Function

Public Sub deleteArrayMenu(ByRef Index As Integer, ByRef MenuArray As Object)
    Dim i As Integer
    
    If (Index <= MenuArray.ubound) Then
        For i = Index To MenuArray.ubound - 1
            MenuArray(i).Caption = MenuArray(i + 1).Caption
        Next i
        
        If (MenuArray.ubound = 0) Then
            MenuArray(MenuArray.ubound).Caption = vbNullString
        Else
            Unload MenuArray(MenuArray.ubound)
        End If
    End If
End Sub


Public Function DebugOutput(ByVal sIn As String) As String
     Dim x1 As Long, y1 As Long
     Dim iLen As Long, iPos As Long
     Dim sB As String, ST As String
     Dim sOut As String
     Dim Offset As Long, sOffset As String

     'build random string to display
 '    y1 = 256
 '    sIn = String(y1, 0)
 '    For x1 = 1 To 256
 '        Mid(sIn, x1, 1) = Chr(x1 - 1)
 '        'Mid(sIn, x1, 1) = Chr(255 * Rnd())
 '    Next x1

     iLen = Len(sIn)
     If iLen = 0 Then Exit Function
     sOut = vbNullString
     Offset = 0
     For x1 = 0 To ((iLen - 1) \ 16)
         sOffset = Right$("0000" & Hex(Offset), 4)
         sB = String(48, Space(1))
         ST = "................"
         For y1 = 1 To 16
             iPos = 16 * x1 + y1
             If iPos > iLen Then Exit For
             Mid(sB, 3 * (y1 - 1) + 1, 2) = Right("00" & Hex(Asc(Mid(sIn, iPos, 1))), 2) & Space(1)
             Select Case Asc(Mid(sIn, iPos, 1))
             Case 0, 9, 10, 13
             Case Else
                 Mid(ST, y1, 1) = Mid(sIn, iPos, 1)
             End Select
         Next y1
         If Len(sOut) > 0 Then sOut = sOut & vbCrLf
         sOut = sOut & sOffset & ":  "
         sOut = sOut & sB & "  " & ST
         Offset = Offset + 16
     Next x1
     DebugOutput = sOut
 End Function
